-- Custom Attributes MacroScript Struct Definition File
--
-- Created:  		Nov 7 2000
-- Last Updated: 	March 30, 2004 - Larry Minton 
--
-- Author :   Frank DeLise / Installed into stdplugs\stdscrpts by jbw 11.7.00
-- Version:  3D Studio Max Version 7.0
--
-- 
-- Custom Attributes Macroscript Struct Definition file.
--
--    Must reside in stdplugs\stdscripts for Custom Attribute dialogs to work.
--
-- Revision History:
--	March 30, 2004 - Larry Minton,
--		added Array and Alpha to CAT_UIItem
--  August 08, 2014 - Xiaoyue Wu,
--      added CAT_UIItem2 which uses absolute layout
--
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
--

----------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Paramblock Definition
----------------------------------------------------------------------------------------------------------------------------------------------------------------

Struct CAT_ParamBlock
(
	Name,	-- the name of the parameter
	Type,	-- the type of the parameter
	UI,		-- the name of the rollout ui item
	Default = "", -- the default value for the parameter
	OrigName -- the original name of the parameter. Used when editting attributes
)

----------------------------------------------------------------------------------------------------------------------------------------------------------------
-- UI Items Definition
----------------------------------------------------------------------------------------------------------------------------------------------------------------
Struct CAT_UIItem
(
	UI, 								-- ui item type
	Name,								-- ui item name
	String,								-- ui item caption
	Type,								-- value type
	Range = "[0,100,0]",				-- spinner, slider
	Default = "1",						-- default value
	Width = "70",						-- ui item width
	Height = "25",						-- ui item height
	Enabled = "True",					-- not used
	Orient = "Horizontal",				-- slider
	Checked = "False",					-- not used
	Color = "(color 0 0 0)",			-- colorswatch default color
	HighLightColor = "(color 0 255 0)",	-- checkbutton
	Align = "Left",						-- alignment
	Items = "#()",						-- typically contains var name pointing at array
	Ticks = "10",						-- slider
	Array = #(),						-- array of strings
	Alpha = "False",					-- colorpicker - true if frgba
	Offset = "[0,0]",					-- UI control offset
	LabelOnTop = "False"				-- Label on top for edittext
)

----------------------------------------------------------------------------------------------------------------------------------------------------------------
-- UI Items Definition: Version 2, use absolute layout
----------------------------------------------------------------------------------------------------------------------------------------------------------------
Struct CAT_UIItem2
(
	UI, 								-- ui item type
	Name,								-- ui item name
	String,								-- ui item caption
	Type,								-- value type
	Align = "Left",						-- alignment, not used here, just for compatiblity
	Offset = "[0,0]",					-- UI control offset, not used here, just for compatiblity
	Range = "[0,100,0]",				-- spinner, slider
	Default = "1",						-- default value
	Width = "70",						-- ui item width
	Height = "25",						-- ui item height
	Enabled = "True",					-- not used
	Orient = "Horizontal",				-- slider
	Checked = "False",					-- not used
	Color = "(color 0 0 0)",			-- colorswatch default color
	HighLightColor = "(color 0 255 0)",	-- checkbutton
	Items = "#()",						-- typically contains var name pointing at array
	Ticks = "10",						-- slider
	Array = #(),						-- array of strings
	Alpha = "False",					-- colorpicker - true if frgba
	Pos = "[0,0]",						-- absolute position of ui item
	LabelOnTop = "False"				-- Label on top for edittext
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA5RwWSHavtM4ZuYiU8NPmMf89SSpuYrLYB
-- OFl7ronPKCRl3sd6H1WvgtKJy5nlcnT3H6HU4Hy4AnQFrNsjQPIEqORVSxtGIP6P
-- sM5KZSmD+ZhfeMMXg7r+FqHh26R55m1UZPtrc/H7KXhwLQLoKACBUjdWF+92JayG
-- WCA8exasapjVIifN/9LHhyuFm9F7ni39ayuxjMX/C/aq5kCwtCnsH0fnkIKhTKbB
-- /5bGzl0+FSDea6GhzX/Gp4ZjoYaHQb7NdEvbfCYXLESK9rgt8P6SUKyFskYIZqg6
-- OYfbQiNkbVCkIO89bh7C9Wt8+wK9B7iWDxtwi7Zdci/nn1UkY9V8
-- -----END-SIGNATURE-----